<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Hashtag\Post;

use Exception;
use Erlage\Photogram\Data\Models\AbstractModel;
use Erlage\Photogram\Data\Tables\Hashtag\HashtagPostTable;

final class HashtagPostModel extends AbstractModel implements InterfaceHashtagPostGetter
{
    /**
     * getter interface
     */
    use TraitHashtagPostGetters;

    public function getTableClassName(): string
    {
        return HashtagPostTable::erlClass();
    }

    /*
    |--------------------------------------------------------------------------
    | override the delete logic
    |--------------------------------------------------------------------------
    */

    public function delete(): bool
    {
        throw new Exception('PostModel should delete hashtagpost(s)');
    }
}
